/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.column;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.column.SerialType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ColumnWithSerialType
implements DbObject,
ColumnNameAware,
Comparable<ColumnWithSerialType> {
    private final Column column;
    private final SerialType serialType;
    private final String sequenceName;

    private ColumnWithSerialType(@Nonnull Column column, @Nonnull SerialType serialType, @Nonnull String sequenceName) {
        this.column = Objects.requireNonNull(column, "column cannot be null");
        this.serialType = Objects.requireNonNull(serialType, "serialType cannot be null");
        this.sequenceName = Validators.notBlank(sequenceName, "sequenceName");
    }

    @Override
    @Nonnull
    public String getName() {
        return this.column.getName();
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.column.getTableName();
    }

    @Override
    @Nonnull
    public String getColumnName() {
        return this.column.getColumnName();
    }

    @Override
    public boolean isNotNull() {
        return this.column.isNotNull();
    }

    @Nonnull
    public SerialType getSerialType() {
        return this.serialType;
    }

    @Nonnull
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Nonnull
    public String toString() {
        return ColumnWithSerialType.class.getSimpleName() + "{column=" + this.column + ", serialType=" + this.serialType + ", sequenceName='" + this.sequenceName + "'}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColumnWithSerialType)) {
            return false;
        }
        ColumnWithSerialType that = (ColumnWithSerialType)other;
        return Objects.equals(this.column, that.column) && Objects.equals((Object)this.serialType, (Object)that.serialType) && Objects.equals(this.sequenceName, that.sequenceName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.serialType, this.sequenceName});
    }

    @Override
    public int compareTo(@Nonnull ColumnWithSerialType other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.column.equals(other.column)) {
            return this.column.compareTo(other.column);
        }
        if (this.serialType != other.serialType) {
            return this.serialType.compareTo(other.serialType);
        }
        return this.sequenceName.compareTo(other.sequenceName);
    }

    @Nonnull
    public static ColumnWithSerialType of(@Nonnull Column column, @Nonnull SerialType serialType, @Nonnull String sequenceName) {
        return new ColumnWithSerialType(column, serialType, sequenceName);
    }

    @Nonnull
    public static ColumnWithSerialType ofBigSerial(@Nonnull Column column, @Nonnull String sequenceName) {
        return ColumnWithSerialType.of(column, SerialType.BIG_SERIAL, sequenceName);
    }

    @Nonnull
    public static ColumnWithSerialType ofSerial(@Nonnull Column column, @Nonnull String sequenceName) {
        return ColumnWithSerialType.of(column, SerialType.SERIAL, sequenceName);
    }

    @Nonnull
    public static ColumnWithSerialType ofSmallSerial(@Nonnull Column column, @Nonnull String sequenceName) {
        return ColumnWithSerialType.of(column, SerialType.SMALL_SERIAL, sequenceName);
    }
}

