/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.column;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public enum SerialType {
    SMALL_SERIAL("smallserial"),
    SERIAL("serial"),
    BIG_SERIAL("bigserial");

    private static final Map<String, SerialType> VALUES;
    private final String columnType;

    private SerialType(String columnType) {
        this.columnType = Objects.requireNonNull(columnType);
    }

    @Nonnull
    public String getColumnType() {
        return this.columnType;
    }

    @Nonnull
    public String toString() {
        return SerialType.class.getSimpleName() + "{columnType='" + this.columnType + "'}";
    }

    @Nonnull
    public static SerialType valueFrom(@Nonnull String pgColumnType) {
        Objects.requireNonNull(pgColumnType, "pgColumnType cannot be null");
        SerialType serialType = VALUES.get(pgColumnType);
        if (serialType == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "pgColumnType = '%s'", pgColumnType));
        }
        return serialType;
    }

    static {
        VALUES = new HashMap<String, SerialType>();
        for (SerialType serialType : SerialType.values()) {
            VALUES.put(serialType.columnType, serialType);
        }
    }
}

