/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.constraint.Constraint;
import io.github.mfvanek.pg.model.constraint.ForeignKey;
import io.github.mfvanek.pg.model.index.utils.DuplicatedIndexesParser;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DuplicatedForeignKeys
implements DbObject,
TableNameAware {
    private final List<ForeignKey> foreignKeys;
    private final List<String> foreignKeysNames;

    private DuplicatedForeignKeys(@Nonnull List<ForeignKey> foreignKeys) {
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(foreignKeys, "foreignKeys cannot be null"));
        Validators.validateThatTableIsTheSame(defensiveCopy);
        this.foreignKeys = defensiveCopy;
        this.foreignKeysNames = this.foreignKeys.stream().map(Constraint::getConstraintName).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Nonnull
    public final String getName() {
        return String.join((CharSequence)",", this.foreignKeysNames);
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.foreignKeys.get(0).getTableName();
    }

    @Nonnull
    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DuplicatedForeignKeys)) {
            return false;
        }
        DuplicatedForeignKeys that = (DuplicatedForeignKeys)other;
        return Objects.equals(this.foreignKeys, that.foreignKeys);
    }

    public final int hashCode() {
        return Objects.hash(this.foreignKeys);
    }

    @Nonnull
    public String toString() {
        return DuplicatedForeignKeys.class.getSimpleName() + "{tableName='" + this.getTableName() + "', foreignKeys=" + this.foreignKeys + "}";
    }

    @Nonnull
    public static DuplicatedForeignKeys of(@Nonnull List<ForeignKey> foreignKeys) {
        return new DuplicatedForeignKeys(foreignKeys);
    }

    @Nonnull
    public static DuplicatedForeignKeys of(@Nonnull ForeignKey firstForeignKey, @Nonnull ForeignKey secondForeignKey, ForeignKey ... otherForeignKeys) {
        return new DuplicatedForeignKeys(DuplicatedIndexesParser.combine((TableNameAware)firstForeignKey, (TableNameAware)secondForeignKey, (TableNameAware[])otherForeignKeys));
    }
}

