/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.constraint.Constraint;
import io.github.mfvanek.pg.model.constraint.ConstraintType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ForeignKey
extends Constraint {
    private final List<Column> columnsInConstraint;

    private ForeignKey(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull List<Column> columnsInConstraint) {
        super(tableName, constraintName, ConstraintType.FOREIGN_KEY);
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(columnsInConstraint, "columnsInConstraint cannot be null"));
        Validators.validateThatNotEmpty(defensiveCopy);
        Validators.validateThatTableIsTheSame(tableName, defensiveCopy);
        this.columnsInConstraint = defensiveCopy;
    }

    @Nonnull
    public List<Column> getColumnsInConstraint() {
        return this.columnsInConstraint;
    }

    @Override
    @Nonnull
    public String toString() {
        return ForeignKey.class.getSimpleName() + "{" + this.innerToString() + ", columnsInConstraint=" + this.columnsInConstraint + "}";
    }

    @Nonnull
    public static ForeignKey of(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull List<Column> columnsInConstraint) {
        return new ForeignKey(tableName, constraintName, columnsInConstraint);
    }

    @Nonnull
    public static ForeignKey ofColumn(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull Column column) {
        return new ForeignKey(tableName, constraintName, List.of(Objects.requireNonNull(column, "column cannot be null")));
    }

    @Nonnull
    public static ForeignKey ofNotNullColumn(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull String columnName) {
        return ForeignKey.ofColumn(tableName, constraintName, Column.ofNotNull(tableName, columnName));
    }

    @Nonnull
    public static ForeignKey ofNullableColumn(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull String columnName) {
        return ForeignKey.ofColumn(tableName, constraintName, Column.ofNullable(tableName, columnName));
    }
}

