/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.index.IndexBloatAware;
import io.github.mfvanek.pg.model.index.IndexWithSize;
import io.github.mfvanek.pg.model.validation.Validators;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexWithBloat
extends IndexWithSize
implements IndexBloatAware {
    private final long bloatSizeInBytes;
    private final double bloatPercentage;

    private IndexWithBloat(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, long bloatSizeInBytes, double bloatPercentage) {
        super(tableName, indexName, indexSizeInBytes);
        this.bloatSizeInBytes = Validators.sizeNotNegative(bloatSizeInBytes, "bloatSizeInBytes");
        this.bloatPercentage = Validators.validPercent(bloatPercentage, "bloatPercentage");
    }

    @Override
    public long getBloatSizeInBytes() {
        return this.bloatSizeInBytes;
    }

    @Override
    public double getBloatPercentage() {
        return this.bloatPercentage;
    }

    @Override
    @Nonnull
    protected String innerToString() {
        return super.innerToString() + ", bloatSizeInBytes=" + this.bloatSizeInBytes + ", bloatPercentage=" + this.bloatPercentage;
    }

    @Override
    @Nonnull
    public String toString() {
        return IndexWithBloat.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    @Nonnull
    public static IndexWithBloat of(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, long bloatSizeInBytes, double bloatPercentage) {
        return new IndexWithBloat(tableName, indexName, indexSizeInBytes, bloatSizeInBytes, bloatPercentage);
    }
}

