/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.index.IndexWithColumns;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IndexWithNulls
extends IndexWithColumns {
    private IndexWithNulls(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull Column nullableColumn) {
        super(tableName, indexName, indexSizeInBytes, List.of(Objects.requireNonNull(nullableColumn, "nullableColumn cannot be null")));
    }

    @Nonnull
    public Column getNullableColumn() {
        return this.getColumns().get(0);
    }

    @Override
    @Nonnull
    public String toString() {
        return IndexWithNulls.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    @Nonnull
    public static IndexWithNulls of(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull String nullableColumnName) {
        return new IndexWithNulls(tableName, indexName, indexSizeInBytes, Column.ofNullable(tableName, nullableColumnName));
    }
}

