/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.index.IndexSizeAware;
import io.github.mfvanek.pg.model.validation.Validators;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexWithSize
extends Index
implements IndexSizeAware {
    private final long indexSizeInBytes;

    protected IndexWithSize(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes) {
        super(tableName, indexName);
        this.indexSizeInBytes = Validators.sizeNotNegative(indexSizeInBytes, "indexSizeInBytes");
    }

    @Override
    public long getIndexSizeInBytes() {
        return this.indexSizeInBytes;
    }

    @Override
    @Nonnull
    protected String innerToString() {
        return super.innerToString() + ", indexSizeInBytes=" + this.indexSizeInBytes;
    }

    @Override
    @Nonnull
    public String toString() {
        return IndexWithSize.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    @Nonnull
    public static IndexWithSize of(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes) {
        return new IndexWithSize(tableName, indexName, indexSizeInBytes);
    }
}

