/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.sequence;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SequenceState
implements DbObject {
    private final String sequenceName;
    private final String dataType;
    private final double remainingPercentage;

    private SequenceState(@Nonnull String sequenceName, @Nonnull String dataType, double remainingPercentage) {
        this.sequenceName = Validators.notBlank(sequenceName, "sequenceName");
        this.dataType = Validators.notBlank(dataType, "dataType");
        this.remainingPercentage = Validators.validPercent(remainingPercentage, "remainingPercentage");
    }

    @Nonnull
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Nonnull
    public String getDataType() {
        return this.dataType;
    }

    public double getRemainingPercentage() {
        return this.remainingPercentage;
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getSequenceName();
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SequenceState)) {
            return false;
        }
        SequenceState that = (SequenceState)other;
        return Objects.equals(this.sequenceName, that.sequenceName);
    }

    public final int hashCode() {
        return Objects.hash(this.sequenceName);
    }

    public String toString() {
        return SequenceState.class.getSimpleName() + "{sequenceName='" + this.sequenceName + "', dataType='" + this.dataType + "', remainingPercentage=" + this.remainingPercentage + "}";
    }

    @Nonnull
    public static SequenceState of(@Nonnull String sequenceName, @Nonnull String dataType, double remainingPercentage) {
        return new SequenceState(sequenceName, dataType, remainingPercentage);
    }
}

