/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.validation;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.table.TableNameAware;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class Validators {
    private Validators() {
        throw new UnsupportedOperationException();
    }

    public static long valueIsPositive(long argumentValue, @Nonnull String argumentName) {
        if (argumentValue <= 0L) {
            throw new IllegalArgumentException(argumentName + " should be greater than zero");
        }
        return argumentValue;
    }

    @Nonnull
    public static String tableNameNotBlank(@Nonnull String tableName) {
        return Validators.notBlank(tableName, "tableName");
    }

    @Nonnull
    public static String indexNameNotBlank(@Nonnull String indexName) {
        return Validators.notBlank(indexName, "indexName");
    }

    @Nonnull
    public static String notBlank(@Nonnull String argumentValue, @Nonnull String argumentName) {
        if (Objects.requireNonNull(argumentValue, argumentName + " cannot be null").isBlank()) {
            throw new IllegalArgumentException(argumentName + " cannot be blank");
        }
        return argumentValue;
    }

    public static long sizeNotNegative(long sizeInBytes, @Nonnull String argumentName) {
        return Validators.argumentNotNegative(sizeInBytes, argumentName);
    }

    public static long countNotNegative(long count, @Nonnull String argumentName) {
        return Validators.argumentNotNegative(count, argumentName);
    }

    public static int argumentNotNegative(int argumentValue, @Nonnull String argumentName) {
        if (argumentValue < 0) {
            throw new IllegalArgumentException(argumentName + " cannot be less than zero");
        }
        return argumentValue;
    }

    private static long argumentNotNegative(long argumentValue, @Nonnull String argumentName) {
        if (argumentValue < 0L) {
            throw new IllegalArgumentException(argumentName + " cannot be less than zero");
        }
        return argumentValue;
    }

    public static void validateThatTableIsTheSame(@Nonnull String expectedTableName, @Nonnull List<? extends TableNameAware> rows) {
        boolean tableIsTheSame = rows.stream().allMatch(i -> i.getTableName().equals(expectedTableName));
        if (!tableIsTheSame) {
            throw new IllegalArgumentException("Table name is not the same within given rows");
        }
    }

    public static <T extends TableNameAware & DbObject> void validateThatTableIsTheSame(@Nonnull List<T> rows) {
        String tableName = ((TableNameAware)Validators.validateThatContainsAtLeastTwoRows(rows).get(0)).getTableName();
        Validators.validateThatTableIsTheSame(tableName, rows);
    }

    @Nonnull
    private static <T extends TableNameAware & DbObject> List<T> validateThatContainsAtLeastTwoRows(@Nonnull List<T> rows) {
        int size = Objects.requireNonNull(rows, "rows cannot be null").size();
        if (0 == size) {
            throw new IllegalArgumentException("rows cannot be empty");
        }
        if (size < 2) {
            throw new IllegalArgumentException("rows should contains at least two items");
        }
        return rows;
    }

    public static <T> void validateThatNotEmpty(@Nonnull List<T> columnsInConstraint) {
        if (columnsInConstraint.isEmpty()) {
            throw new IllegalArgumentException("columnsInConstraint cannot be empty");
        }
    }

    public static double validPercent(double percentValue, @Nonnull String argumentName) {
        if (percentValue < 0.0 || percentValue > 100.0) {
            throw new IllegalArgumentException(argumentName + " should be in the range from 0.0 to 100.0 inclusive");
        }
        return percentValue;
    }
}

