/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.settings;

import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.settings.ServerSpecificationBuilder;
import javax.annotation.Nonnull;

public class ServerSpecification {
    private final int cpuCoresAmount;
    private final long memoryAmountInBytes;
    private final boolean hasSSD;

    ServerSpecification(int cpuCoresAmount, long memoryAmountInBytes, boolean hasSSD) {
        Validators.valueIsPositive(cpuCoresAmount, "cpuCoresAmount");
        this.cpuCoresAmount = cpuCoresAmount;
        this.memoryAmountInBytes = Validators.valueIsPositive(memoryAmountInBytes, "memoryAmountInBytes");
        this.hasSSD = hasSSD;
    }

    public int getCpuCoresAmount() {
        return this.cpuCoresAmount;
    }

    public long getMemoryAmountInBytes() {
        return this.memoryAmountInBytes;
    }

    public boolean hasSSD() {
        return this.hasSSD;
    }

    @Nonnull
    public String toString() {
        return ServerSpecification.class.getSimpleName() + "{cpuCoresAmount=" + this.cpuCoresAmount + ", memoryAmountInBytes=" + this.memoryAmountInBytes + ", hasSSD=" + this.hasSSD + "}";
    }

    @Nonnull
    public static ServerSpecificationBuilder builder() {
        return new ServerSpecificationBuilder();
    }
}

