/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.column;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.column.SerialType;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.sequence.SequenceNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class ColumnWithSerialType
implements DbObject,
ColumnNameAware,
SequenceNameAware,
Comparable<ColumnWithSerialType> {
    private final Column column;
    private final SerialType serialType;
    private final String sequenceName;

    private ColumnWithSerialType(Column column, SerialType serialType, String sequenceName) {
        this.column = Objects.requireNonNull(column, "column cannot be null");
        this.serialType = Objects.requireNonNull(serialType, "serialType cannot be null");
        this.sequenceName = Validators.notBlank(sequenceName, "sequenceName");
    }

    @Override
    public String getName() {
        return this.column.getName();
    }

    @Override
    public PgObjectType getObjectType() {
        return this.column.getObjectType();
    }

    @Override
    public String getTableName() {
        return this.column.getTableName();
    }

    @Override
    public String getColumnName() {
        return this.column.getColumnName();
    }

    @Override
    public boolean isNotNull() {
        return this.column.isNotNull();
    }

    public SerialType getSerialType() {
        return this.serialType;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    public String toString() {
        return ColumnWithSerialType.class.getSimpleName() + "{column=" + this.column + ", serialType=" + this.serialType + ", sequenceName='" + this.sequenceName + "'}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColumnWithSerialType)) {
            return false;
        }
        ColumnWithSerialType that = (ColumnWithSerialType)other;
        return Objects.equals(this.column, that.column) && Objects.equals((Object)this.serialType, (Object)that.serialType) && Objects.equals(this.sequenceName, that.sequenceName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.serialType, this.sequenceName});
    }

    @Override
    public int compareTo(ColumnWithSerialType other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.column.equals(other.column)) {
            return this.column.compareTo(other.column);
        }
        if (this.serialType != other.serialType) {
            return this.serialType.compareTo(other.serialType);
        }
        return this.sequenceName.compareTo(other.sequenceName);
    }

    public static ColumnWithSerialType of(Column column, SerialType serialType, String sequenceName) {
        return new ColumnWithSerialType(column, serialType, sequenceName);
    }

    public static ColumnWithSerialType of(PgContext pgContext, Column column, SerialType serialType, String sequenceName) {
        return ColumnWithSerialType.of(column, serialType, PgContext.enrichWith(sequenceName, pgContext));
    }

    public static ColumnWithSerialType ofBigSerial(Column column, String sequenceName) {
        return ColumnWithSerialType.of(column, SerialType.BIG_SERIAL, sequenceName);
    }

    public static ColumnWithSerialType ofBigSerial(PgContext pgContext, Column column, String sequenceName) {
        return ColumnWithSerialType.ofBigSerial(column, PgContext.enrichWith(sequenceName, pgContext));
    }

    public static ColumnWithSerialType ofSerial(Column column, String sequenceName) {
        return ColumnWithSerialType.of(column, SerialType.SERIAL, sequenceName);
    }

    public static ColumnWithSerialType ofSerial(PgContext pgContext, Column column, String sequenceName) {
        return ColumnWithSerialType.ofSerial(column, PgContext.enrichWith(sequenceName, pgContext));
    }

    public static ColumnWithSerialType ofSmallSerial(Column column, String sequenceName) {
        return ColumnWithSerialType.of(column, SerialType.SMALL_SERIAL, sequenceName);
    }

    public static ColumnWithSerialType ofSmallSerial(PgContext pgContext, Column column, String sequenceName) {
        return ColumnWithSerialType.ofSmallSerial(column, PgContext.enrichWith(sequenceName, pgContext));
    }
}

