/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.constraint.ConstraintNameAware;
import io.github.mfvanek.pg.model.constraint.ConstraintType;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Locale;
import java.util.Objects;

public final class Constraint
implements DbObject,
ConstraintNameAware {
    private final String tableName;
    private final String constraintName;
    private final ConstraintType constraintType;

    private Constraint(String tableName, String constraintName, ConstraintType constraintType) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.constraintName = Validators.notBlank(constraintName, "constraintName");
        this.constraintType = Objects.requireNonNull(constraintType, "constraintType cannot be null");
    }

    @Override
    public String getName() {
        return this.getConstraintName();
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.CONSTRAINT;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Constraint)) {
            return false;
        }
        Constraint that = (Constraint)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.constraintName, that.constraintName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.constraintName);
    }

    String innerToString() {
        return "tableName='" + this.tableName + "', constraintName='" + this.constraintName + "'";
    }

    public String toString() {
        return Constraint.class.getSimpleName() + "{" + this.innerToString() + ", constraintType=" + this.constraintType + "}";
    }

    public String getValidateSql() {
        return String.format(Locale.ROOT, "alter table %s validate constraint %s;", this.tableName, this.constraintName);
    }

    public static Constraint ofType(String tableName, String constraintName, ConstraintType constraintType) {
        return new Constraint(tableName, constraintName, constraintType);
    }

    public static Constraint ofType(PgContext pgContext, String tableName, String constraintName, ConstraintType constraintType) {
        return Constraint.ofType(PgContext.enrichWith(tableName, pgContext), constraintName, constraintType);
    }
}

