/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import java.util.Objects;

public enum ConstraintType {
    CHECK("c"),
    FOREIGN_KEY("f");

    private final String pgConType;

    private ConstraintType(String pgConType) {
        this.pgConType = Objects.requireNonNull(pgConType, "pgConType");
    }

    public String getPgConType() {
        return this.pgConType;
    }

    public static ConstraintType valueFrom(String pgConType) {
        Objects.requireNonNull(pgConType, "pgConType cannot be null");
        for (ConstraintType ct : ConstraintType.values()) {
            if (!ct.getPgConType().equals(pgConType)) continue;
            return ct;
        }
        throw new IllegalArgumentException("Unknown pgConType: " + pgConType);
    }
}

