/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.dbobject;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class AnyObject
implements DbObject,
Comparable<AnyObject> {
    private final String objectName;
    private final PgObjectType objectType;

    private AnyObject(String objectName, PgObjectType objectType) {
        this.objectName = Validators.notBlank(objectName, "objectName");
        this.objectType = Objects.requireNonNull(objectType, "objectType cannot be null");
    }

    @Override
    public String getName() {
        return this.objectName;
    }

    @Override
    public PgObjectType getObjectType() {
        return this.objectType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnyObject)) {
            return false;
        }
        AnyObject that = (AnyObject)other;
        return Objects.equals(this.objectName, that.objectName) && Objects.equals((Object)this.objectType, (Object)that.objectType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectName, this.objectType});
    }

    public String toString() {
        return AnyObject.class.getSimpleName() + "{objectName='" + this.objectName + "', objectType=" + this.objectType + "}";
    }

    @Override
    public int compareTo(AnyObject other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (this.objectType != other.objectType) {
            return this.objectType.compareTo(other.objectType);
        }
        return this.objectName.compareTo(other.objectName);
    }

    public static AnyObject ofType(String objectName, PgObjectType objectType) {
        return new AnyObject(objectName, objectType);
    }

    public static AnyObject ofType(PgContext pgContext, String objectName, PgObjectType objectType) {
        return AnyObject.ofType(PgContext.enrichWith(objectName, pgContext), objectType);
    }

    public static AnyObject ofRaw(String objectName, String objectType) {
        return new AnyObject(objectName, PgObjectType.valueFrom(objectType));
    }
}

