/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.function;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class StoredFunction
implements DbObject,
Comparable<StoredFunction> {
    private final String functionName;
    private final String functionSignature;

    private StoredFunction(String functionName, String functionSignature) {
        this.functionName = Validators.notBlank(functionName, "functionName");
        this.functionSignature = Objects.requireNonNull(functionSignature, "functionSignature cannot be null").trim();
    }

    @Override
    public String getName() {
        return this.getFunctionName();
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.FUNCTION;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionSignature() {
        return this.functionSignature;
    }

    public String toString() {
        return StoredFunction.class.getSimpleName() + "{functionName='" + this.functionName + "', functionSignature='" + this.functionSignature + "'}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StoredFunction)) {
            return false;
        }
        StoredFunction that = (StoredFunction)other;
        return Objects.equals(this.functionName, that.functionName) && Objects.equals(this.functionSignature, that.functionSignature);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.functionSignature);
    }

    @Override
    public int compareTo(StoredFunction other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.functionName.equals(other.functionName)) {
            return this.functionName.compareTo(other.functionName);
        }
        return this.functionSignature.compareTo(other.functionSignature);
    }

    public static StoredFunction ofNoArgs(String functionName) {
        return new StoredFunction(functionName, "");
    }

    public static StoredFunction ofNoArgs(PgContext pgContext, String functionName) {
        return StoredFunction.ofNoArgs(PgContext.enrichWith(functionName, pgContext));
    }

    public static StoredFunction of(String functionName, String functionSignature) {
        return new StoredFunction(functionName, functionSignature);
    }

    public static StoredFunction of(PgContext pgContext, String functionName, String functionSignature) {
        return StoredFunction.of(PgContext.enrichWith(functionName, pgContext), functionSignature);
    }
}

