/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.index.IndexSizeAware;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class Index
implements DbObject,
TableNameAware,
IndexSizeAware,
Comparable<Index> {
    private final String tableName;
    private final String indexName;
    private final long indexSizeInBytes;

    private Index(String tableName, String indexName, long indexSizeInBytes) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.indexName = Validators.indexNameNotBlank(indexName);
        this.indexSizeInBytes = Validators.sizeNotNegative(indexSizeInBytes, "indexSizeInBytes");
    }

    @Override
    public String getName() {
        return this.getIndexName();
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.INDEX;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public long getIndexSizeInBytes() {
        return this.indexSizeInBytes;
    }

    public String toString() {
        return Index.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    String innerToString() {
        return "tableName='" + this.tableName + "', indexName='" + this.indexName + "', indexSizeInBytes=" + this.indexSizeInBytes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Index)) {
            return false;
        }
        Index that = (Index)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.indexName, that.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.indexName);
    }

    @Override
    public int compareTo(Index other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.tableName.equals(other.tableName)) {
            return this.tableName.compareTo(other.tableName);
        }
        return this.indexName.compareTo(other.indexName);
    }

    public static Index of(String tableName, String indexName, long indexSizeInBytes) {
        return new Index(tableName, indexName, indexSizeInBytes);
    }

    public static Index of(PgContext pgContext, String tableName, String indexName, long indexSizeInBytes) {
        return Index.of(PgContext.enrichWith(tableName, pgContext), PgContext.enrichWith(indexName, pgContext), indexSizeInBytes);
    }

    public static Index of(String tableName, String indexName) {
        return Index.of(tableName, indexName, 0L);
    }

    public static Index of(PgContext pgContext, String tableName, String indexName) {
        return Index.of(pgContext, tableName, indexName, 0L);
    }
}

