/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.bloat.BloatAware;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.index.AbstractIndexAware;
import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class IndexWithBloat
extends AbstractIndexAware
implements BloatAware,
Comparable<IndexWithBloat> {
    private final long bloatSizeInBytes;
    private final double bloatPercentage;

    private IndexWithBloat(Index index, long bloatSizeInBytes, double bloatPercentage) {
        super(index);
        this.bloatSizeInBytes = Validators.sizeNotNegative(bloatSizeInBytes, "bloatSizeInBytes");
        this.bloatPercentage = Validators.validPercent(bloatPercentage, "bloatPercentage");
    }

    @Override
    public long getBloatSizeInBytes() {
        return this.bloatSizeInBytes;
    }

    @Override
    public double getBloatPercentage() {
        return this.bloatPercentage;
    }

    public String toString() {
        return IndexWithBloat.class.getSimpleName() + "{" + this.index.innerToString() + ", bloatSizeInBytes=" + this.bloatSizeInBytes + ", bloatPercentage=" + this.bloatPercentage + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexWithBloat)) {
            return false;
        }
        IndexWithBloat that = (IndexWithBloat)other;
        return Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hashCode(this.index);
    }

    @Override
    public int compareTo(IndexWithBloat other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.index.compareTo(other.index);
    }

    public static IndexWithBloat of(String tableName, String indexName, long indexSizeInBytes, long bloatSizeInBytes, double bloatPercentage) {
        return IndexWithBloat.of(Index.of(tableName, indexName, indexSizeInBytes), bloatSizeInBytes, bloatPercentage);
    }

    public static IndexWithBloat of(PgContext pgContext, String tableName, String indexName, long indexSizeInBytes, long bloatSizeInBytes, double bloatPercentage) {
        return IndexWithBloat.of(Index.of(pgContext, tableName, indexName, indexSizeInBytes), bloatSizeInBytes, bloatPercentage);
    }

    public static IndexWithBloat of(PgContext pgContext, String tableName, String indexName) {
        return IndexWithBloat.of(pgContext, tableName, indexName, 0L, 0L, 0.0);
    }

    public static IndexWithBloat of(Index index, long bloatSizeInBytes, double bloatPercentage) {
        return new IndexWithBloat(index, bloatSizeInBytes, bloatPercentage);
    }
}

