/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.column.ColumnsAware;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.predicates.AbstractSkipTablesPredicate;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public final class SkipByColumnNamePredicate
implements Predicate<DbObject> {
    private final Set<String> columnNamesToSkip;

    private SkipByColumnNamePredicate(Collection<String> columnNamesToSkip) {
        this.columnNamesToSkip = AbstractSkipTablesPredicate.prepareNamesToSkip(columnNamesToSkip);
    }

    private SkipByColumnNamePredicate(String columnNameToSkip) {
        this(AbstractSkipTablesPredicate.prepareSingleNameToSkip(columnNameToSkip, "columnNameToSkip"));
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (this.columnNamesToSkip.isEmpty()) {
            return true;
        }
        if (dbObject instanceof ColumnNameAware) {
            ColumnNameAware c = (ColumnNameAware)((Object)dbObject);
            return !this.columnNamesToSkip.contains(c.getColumnName().toLowerCase(Locale.ROOT));
        }
        if (dbObject instanceof ColumnsAware) {
            ColumnsAware cs = (ColumnsAware)((Object)dbObject);
            for (ColumnNameAware c : cs.getColumns()) {
                if (!this.columnNamesToSkip.contains(c.getColumnName().toLowerCase(Locale.ROOT))) continue;
                return false;
            }
        }
        return true;
    }

    public static Predicate<DbObject> ofName(String columnNameToSkip) {
        return new SkipByColumnNamePredicate(columnNameToSkip);
    }

    public static Predicate<DbObject> of(Collection<String> columnNamesToSkip) {
        return new SkipByColumnNamePredicate(columnNamesToSkip);
    }
}

