/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.predicates.AbstractSkipTablesPredicate;
import io.github.mfvanek.pg.model.sequence.SequenceNameAware;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public final class SkipBySequenceNamePredicate
implements Predicate<DbObject> {
    private final Set<String> fullyQualifiedSequenceNamesToSkip;

    private SkipBySequenceNamePredicate(PgContext pgContext, Collection<String> rawSequenceNamesToSkip) {
        this.fullyQualifiedSequenceNamesToSkip = AbstractSkipTablesPredicate.prepareFullyQualifiedNamesToSkip(pgContext, rawSequenceNamesToSkip);
    }

    private SkipBySequenceNamePredicate(PgContext pgContext, String rawSequenceNameToSkip) {
        this(pgContext, AbstractSkipTablesPredicate.prepareSingleNameToSkip(rawSequenceNameToSkip, "rawSequenceNameToSkip"));
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (!this.fullyQualifiedSequenceNamesToSkip.isEmpty() && dbObject instanceof SequenceNameAware) {
            SequenceNameAware s = (SequenceNameAware)((Object)dbObject);
            return !this.fullyQualifiedSequenceNamesToSkip.contains(s.getSequenceName().toLowerCase(Locale.ROOT));
        }
        return true;
    }

    public static Predicate<DbObject> ofName(String rawSequenceNameToSkip) {
        return new SkipBySequenceNamePredicate(PgContext.ofDefault(), rawSequenceNameToSkip);
    }

    public static Predicate<DbObject> ofDefault(Collection<String> rawSequenceNamesToSkip) {
        return new SkipBySequenceNamePredicate(PgContext.ofDefault(), rawSequenceNamesToSkip);
    }

    public static Predicate<DbObject> ofName(PgContext pgContext, String rawSequenceNameToSkip) {
        return new SkipBySequenceNamePredicate(pgContext, rawSequenceNameToSkip);
    }

    public static Predicate<DbObject> of(PgContext pgContext, Collection<String> rawSequenceNamesToSkip) {
        return new SkipBySequenceNamePredicate(pgContext, rawSequenceNamesToSkip);
    }
}

