/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.predicates.AbstractSkipTablesPredicate;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SkipDbObjectsByNamePredicate
implements Predicate<DbObject> {
    private final Set<String> fullyQualifiedNamesToSkip;

    private SkipDbObjectsByNamePredicate(Collection<String> fullyQualifiedObjectNamesToSkip) {
        this.fullyQualifiedNamesToSkip = Objects.requireNonNull(fullyQualifiedObjectNamesToSkip, "fullyQualifiedObjectNamesToSkip cannot be null").stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableSet());
    }

    private SkipDbObjectsByNamePredicate(String fullyQualifiedObjectNameToSkip) {
        this(AbstractSkipTablesPredicate.prepareSingleNameToSkip(fullyQualifiedObjectNameToSkip, "fullyQualifiedObjectNameToSkip"));
    }

    @Override
    public boolean test(DbObject objectNameAware) {
        if (this.fullyQualifiedNamesToSkip.isEmpty()) {
            return true;
        }
        return !this.fullyQualifiedNamesToSkip.contains(objectNameAware.getName().toLowerCase(Locale.ROOT));
    }

    public static Predicate<DbObject> ofName(String fullyQualifiedObjectNameToSkip) {
        return new SkipDbObjectsByNamePredicate(fullyQualifiedObjectNameToSkip);
    }

    public static Predicate<DbObject> ofName(PgContext pgContext, String objectNameToSkip) {
        return SkipDbObjectsByNamePredicate.ofName(PgContext.enrichWith(objectNameToSkip, pgContext));
    }

    public static Predicate<DbObject> of(Collection<String> fullyQualifiedObjectNamesToSkip) {
        return new SkipDbObjectsByNamePredicate(fullyQualifiedObjectNamesToSkip);
    }

    public static Predicate<DbObject> of(PgContext pgContext, Collection<String> objectNamesToSkip) {
        return SkipDbObjectsByNamePredicate.of(AbstractSkipTablesPredicate.prepareFullyQualifiedNamesToSkip(pgContext, objectNamesToSkip));
    }
}

