/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.index.IndexNameAware;
import io.github.mfvanek.pg.model.index.IndexesAware;
import io.github.mfvanek.pg.model.predicates.AbstractSkipTablesPredicate;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public final class SkipIndexesByNamePredicate
implements Predicate<DbObject> {
    private final Set<String> fullyQualifiedIndexNamesToSkip;

    private SkipIndexesByNamePredicate(PgContext pgContext, Collection<String> rawIndexNamesToSkip) {
        this.fullyQualifiedIndexNamesToSkip = AbstractSkipTablesPredicate.prepareFullyQualifiedNamesToSkip(pgContext, rawIndexNamesToSkip);
    }

    private SkipIndexesByNamePredicate(PgContext pgContext, String rawIndexNameToSkip) {
        this(pgContext, AbstractSkipTablesPredicate.prepareSingleNameToSkip(rawIndexNameToSkip, "rawIndexNameToSkip"));
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (this.fullyQualifiedIndexNamesToSkip.isEmpty()) {
            return true;
        }
        if (dbObject instanceof IndexNameAware) {
            IndexNameAware i = (IndexNameAware)((Object)dbObject);
            return !this.fullyQualifiedIndexNamesToSkip.contains(i.getIndexName().toLowerCase(Locale.ROOT));
        }
        if (dbObject instanceof IndexesAware) {
            IndexesAware i = (IndexesAware)((Object)dbObject);
            for (Index index : i.getIndexes()) {
                if (!this.fullyQualifiedIndexNamesToSkip.contains(index.getIndexName().toLowerCase(Locale.ROOT))) continue;
                return false;
            }
        }
        return true;
    }

    public static Predicate<DbObject> ofName(String rawIndexNameToSkip) {
        return new SkipIndexesByNamePredicate(PgContext.ofDefault(), rawIndexNameToSkip);
    }

    public static Predicate<DbObject> ofDefault(Collection<String> rawIndexNamesToSkip) {
        return new SkipIndexesByNamePredicate(PgContext.ofDefault(), rawIndexNamesToSkip);
    }

    public static Predicate<DbObject> ofName(PgContext pgContext, String rawIndexNameToSkip) {
        return new SkipIndexesByNamePredicate(pgContext, rawIndexNameToSkip);
    }

    public static Predicate<DbObject> of(PgContext pgContext, Collection<String> rawIndexNamesToSkip) {
        return new SkipIndexesByNamePredicate(pgContext, rawIndexNamesToSkip);
    }
}

