/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.predicates.AbstractFilterBySize;
import io.github.mfvanek.pg.model.table.TableSizeAware;
import java.util.function.Predicate;

public final class SkipSmallTablesPredicate
extends AbstractFilterBySize {
    private SkipSmallTablesPredicate(long thresholdInBytes) {
        super(thresholdInBytes);
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (this.thresholdInBytes == 0L) {
            return true;
        }
        if (!(dbObject instanceof TableSizeAware)) {
            return true;
        }
        TableSizeAware tableSizeAware = (TableSizeAware)((Object)dbObject);
        return tableSizeAware.getTableSizeInBytes() >= this.thresholdInBytes;
    }

    public static Predicate<DbObject> of(long thresholdInBytes) {
        return new SkipSmallTablesPredicate(thresholdInBytes);
    }
}

