/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.sequence;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.sequence.SequenceNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class SequenceState
implements DbObject,
SequenceNameAware {
    private final String sequenceName;
    private final String dataType;
    private final double remainingPercentage;

    private SequenceState(String sequenceName, String dataType, double remainingPercentage) {
        this.sequenceName = Validators.notBlank(sequenceName, "sequenceName");
        this.dataType = Validators.notBlank(dataType, "dataType");
        this.remainingPercentage = Validators.validPercent(remainingPercentage, "remainingPercentage");
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public double getRemainingPercentage() {
        return this.remainingPercentage;
    }

    @Override
    public String getName() {
        return this.getSequenceName();
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.SEQUENCE;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SequenceState)) {
            return false;
        }
        SequenceState that = (SequenceState)other;
        return Objects.equals(this.sequenceName, that.sequenceName);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceName);
    }

    public String toString() {
        return SequenceState.class.getSimpleName() + "{sequenceName='" + this.sequenceName + "', dataType='" + this.dataType + "', remainingPercentage=" + this.remainingPercentage + "}";
    }

    public static SequenceState of(String sequenceName, String dataType, double remainingPercentage) {
        return new SequenceState(sequenceName, dataType, remainingPercentage);
    }

    public static SequenceState of(PgContext pgContext, String sequenceName, String dataType, double remainingPercentage) {
        return SequenceState.of(PgContext.enrichWith(sequenceName, pgContext), dataType, remainingPercentage);
    }
}

