/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.table;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.table.AbstractTableAware;
import io.github.mfvanek.pg.model.table.Table;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class TableWithMissingIndex
extends AbstractTableAware
implements Comparable<TableWithMissingIndex> {
    private final long seqScans;
    private final long indexScans;

    private TableWithMissingIndex(Table table, long seqScans, long indexScans) {
        super(table);
        this.seqScans = Validators.countNotNegative(seqScans, "seqScans");
        this.indexScans = Validators.countNotNegative(indexScans, "indexScans");
    }

    public long getSeqScans() {
        return this.seqScans;
    }

    public long getIndexScans() {
        return this.indexScans;
    }

    public String toString() {
        return TableWithMissingIndex.class.getSimpleName() + "{" + this.table.innerToString() + ", seqScans=" + this.seqScans + ", indexScans=" + this.indexScans + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableWithMissingIndex)) {
            return false;
        }
        TableWithMissingIndex that = (TableWithMissingIndex)other;
        return Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public int compareTo(TableWithMissingIndex other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.table.compareTo(other.table);
    }

    public static TableWithMissingIndex of(String tableName, long tableSizeInBytes, long seqScans, long indexScans) {
        Table table = Table.of(tableName, tableSizeInBytes);
        return TableWithMissingIndex.of(table, seqScans, indexScans);
    }

    public static TableWithMissingIndex of(String tableName) {
        return TableWithMissingIndex.of(tableName, 0L, 0L, 0L);
    }

    public static TableWithMissingIndex of(PgContext pgContext, String tableName, long tableSizeInBytes, long seqScans, long indexScans) {
        Table table = Table.of(pgContext, tableName, tableSizeInBytes);
        return TableWithMissingIndex.of(table, seqScans, indexScans);
    }

    public static TableWithMissingIndex of(PgContext pgContext, String tableName) {
        return TableWithMissingIndex.of(pgContext, tableName, 0L, 0L, 0L);
    }

    public static TableWithMissingIndex of(Table table, long seqScans, long indexScans) {
        return new TableWithMissingIndex(table, seqScans, indexScans);
    }
}

