/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.units;

import java.util.Objects;

public enum MemoryUnit {
    KB(1024L, "kilobyte"),
    MB(0x100000L, "megabyte"),
    GB(0x40000000L, "gigabyte");

    private final long dimension;
    private final String description;

    private MemoryUnit(long dimension, String description) {
        this.dimension = dimension;
        this.description = Objects.requireNonNull(description);
    }

    public long convertToBytes(int unitsCount) {
        return (long)unitsCount * this.dimension;
    }

    public String toString() {
        return MemoryUnit.class.getSimpleName() + "{dimension=" + this.dimension + ", description='" + this.description + "'}";
    }
}

