/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.column;

import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class Column
implements DbObject,
ColumnNameAware,
Comparable<Column> {
    private final String tableName;
    private final String columnName;
    private final boolean notNull;

    private Column(String tableName, String columnName, boolean notNull) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.columnName = Validators.notBlank(columnName, "columnName");
        this.notNull = notNull;
    }

    @Override
    public String getName() {
        return this.getColumnName();
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.TABLE;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    public String toString() {
        return Column.class.getSimpleName() + "{tableName='" + this.tableName + "', columnName='" + this.columnName + "', notNull=" + this.notNull + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        Column that = (Column)other;
        return this.notNull == that.notNull && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columnName, that.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.columnName, this.notNull);
    }

    @Override
    public int compareTo(Column other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.tableName.equals(other.tableName)) {
            return this.tableName.compareTo(other.tableName);
        }
        if (!this.columnName.equals(other.columnName)) {
            return this.columnName.compareTo(other.columnName);
        }
        return Boolean.compare(this.notNull, other.notNull);
    }

    public static Column ofNotNull(String tableName, String columnName) {
        return new Column(tableName, columnName, true);
    }

    public static Column ofNotNull(PgContext pgContext, String tableName, String columnName) {
        return Column.ofNotNull(PgContext.enrichWith(tableName, pgContext), columnName);
    }

    public static Column ofNullable(String tableName, String columnName) {
        return new Column(tableName, columnName, false);
    }

    public static Column ofNullable(PgContext pgContext, String tableName, String columnName) {
        return Column.ofNullable(PgContext.enrichWith(tableName, pgContext), columnName);
    }
}

