/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.constraint.ConstraintNameAware;
import io.github.mfvanek.pg.model.constraint.ConstraintsAware;
import io.github.mfvanek.pg.model.constraint.ForeignKey;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.index.utils.DuplicatedIndexesParser;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class DuplicatedForeignKeys
implements DbObject,
TableNameAware,
ConstraintsAware {
    private final List<ForeignKey> foreignKeys;
    private final List<String> foreignKeysNames;

    private DuplicatedForeignKeys(Collection<ForeignKey> foreignKeys) {
        List<ForeignKey> defensiveCopy = List.copyOf(Objects.requireNonNull(foreignKeys, "foreignKeys cannot be null"));
        Validators.validateThatTableIsTheSame(defensiveCopy);
        this.foreignKeys = defensiveCopy;
        this.foreignKeysNames = this.foreignKeys.stream().map(ForeignKey::getConstraintName).toList();
    }

    @Override
    public String getName() {
        return String.join((CharSequence)",", this.foreignKeysNames);
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.CONSTRAINT;
    }

    @Override
    public String getTableName() {
        return this.foreignKeys.get(0).getTableName();
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public List<ConstraintNameAware> getConstraints() {
        return List.copyOf(this.getForeignKeys());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DuplicatedForeignKeys)) {
            return false;
        }
        DuplicatedForeignKeys that = (DuplicatedForeignKeys)other;
        return Objects.equals(this.foreignKeys, that.foreignKeys);
    }

    public int hashCode() {
        return Objects.hash(this.foreignKeys);
    }

    public String toString() {
        return DuplicatedForeignKeys.class.getSimpleName() + "{tableName='" + this.getTableName() + "', foreignKeys=" + this.foreignKeys + "}";
    }

    public static DuplicatedForeignKeys of(Collection<ForeignKey> foreignKeys) {
        return new DuplicatedForeignKeys(foreignKeys);
    }

    public static DuplicatedForeignKeys of(ForeignKey firstForeignKey, ForeignKey secondForeignKey, ForeignKey ... otherForeignKeys) {
        return new DuplicatedForeignKeys(DuplicatedIndexesParser.combine((TableNameAware)firstForeignKey, (TableNameAware)secondForeignKey, (TableNameAware[])otherForeignKeys));
    }
}

