/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.column.ColumnsAware;
import io.github.mfvanek.pg.model.constraint.Constraint;
import io.github.mfvanek.pg.model.constraint.ConstraintNameAware;
import io.github.mfvanek.pg.model.constraint.ConstraintType;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class ForeignKey
implements DbObject,
ConstraintNameAware,
ColumnsAware {
    private final Constraint constraint;
    private final List<Column> columnsInConstraint;

    private ForeignKey(Constraint constraint, List<Column> columnsInConstraint) {
        this.constraint = Objects.requireNonNull(constraint, "constraint cannot be null");
        if (this.constraint.getConstraintType() != ConstraintType.FOREIGN_KEY) {
            throw new IllegalArgumentException("constraint must be foreign key");
        }
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(columnsInConstraint, "columnsInConstraint cannot be null"));
        Validators.validateThatNotEmpty(defensiveCopy);
        Validators.validateThatTableIsTheSame(constraint.getTableName(), defensiveCopy);
        this.columnsInConstraint = defensiveCopy;
    }

    @Override
    public String getConstraintName() {
        return this.constraint.getConstraintName();
    }

    @Override
    public ConstraintType getConstraintType() {
        return this.constraint.getConstraintType();
    }

    @Override
    public String getName() {
        return this.constraint.getName();
    }

    @Override
    public PgObjectType getObjectType() {
        return this.constraint.getObjectType();
    }

    @Override
    public String getTableName() {
        return this.constraint.getTableName();
    }

    @Override
    public List<ColumnNameAware> getColumns() {
        return List.copyOf(this.columnsInConstraint);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForeignKey)) {
            return false;
        }
        ForeignKey that = (ForeignKey)other;
        return Objects.equals(this.constraint, that.constraint);
    }

    public int hashCode() {
        return Objects.hashCode(this.constraint);
    }

    public String toString() {
        return ForeignKey.class.getSimpleName() + "{" + this.constraint.innerToString() + ", columnsInConstraint=" + this.columnsInConstraint + "}";
    }

    private static Constraint toConstraint(String tableName, String constraintName) {
        return Constraint.ofType(tableName, constraintName, ConstraintType.FOREIGN_KEY);
    }

    private static Constraint toConstraint(PgContext pgContext, String tableName, String constraintName) {
        return Constraint.ofType(pgContext, tableName, constraintName, ConstraintType.FOREIGN_KEY);
    }

    public static ForeignKey of(String tableName, String constraintName, List<Column> columnsInConstraint) {
        return new ForeignKey(ForeignKey.toConstraint(tableName, constraintName), columnsInConstraint);
    }

    public static ForeignKey of(PgContext pgContext, String tableName, String constraintName, List<Column> columnsInConstraint) {
        return new ForeignKey(ForeignKey.toConstraint(pgContext, tableName, constraintName), columnsInConstraint);
    }

    public static ForeignKey ofColumn(Constraint constraint, Column column) {
        return new ForeignKey(constraint, List.of(Objects.requireNonNull(column, "column cannot be null")));
    }

    public static ForeignKey ofColumn(String tableName, String constraintName, Column column) {
        return ForeignKey.ofColumn(ForeignKey.toConstraint(tableName, constraintName), column);
    }

    public static ForeignKey ofColumn(PgContext pgContext, String tableName, String constraintName, Column column) {
        return ForeignKey.ofColumn(ForeignKey.toConstraint(pgContext, tableName, constraintName), column);
    }

    public static ForeignKey ofNotNullColumn(String tableName, String constraintName, String columnName) {
        return ForeignKey.ofColumn(tableName, constraintName, Column.ofNotNull(tableName, columnName));
    }

    public static ForeignKey ofNotNullColumn(PgContext pgContext, String tableName, String constraintName, String columnName) {
        return ForeignKey.ofColumn(pgContext, tableName, constraintName, Column.ofNotNull(pgContext, tableName, columnName));
    }

    public static ForeignKey ofNullableColumn(String tableName, String constraintName, String columnName) {
        return ForeignKey.ofColumn(tableName, constraintName, Column.ofNullable(tableName, columnName));
    }

    public static ForeignKey ofNullableColumn(PgContext pgContext, String tableName, String constraintName, String columnName) {
        return ForeignKey.ofColumn(pgContext, tableName, constraintName, Column.ofNullable(pgContext, tableName, columnName));
    }
}

