/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.context;

import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Locale;
import java.util.Objects;

public final class PgContext {
    public static final double DEFAULT_BLOAT_PERCENTAGE_THRESHOLD = 10.0;
    public static final String DEFAULT_SCHEMA_NAME = "public";
    public static final double DEFAULT_REMAINING_PERCENTAGE_THRESHOLD = 10.0;
    private final String schemaName;
    private final double bloatPercentageThreshold;
    private final double remainingPercentageThreshold;

    private PgContext(String schemaName, double bloatPercentageThreshold, double remainingPercentageThreshold) {
        this.schemaName = Validators.notBlank(schemaName, "schemaName").toLowerCase(Locale.ROOT);
        this.bloatPercentageThreshold = Validators.validPercent(bloatPercentageThreshold, "bloatPercentageThreshold");
        this.remainingPercentageThreshold = Validators.validPercent(remainingPercentageThreshold, "remainingPercentageThreshold");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean isDefaultSchema() {
        return DEFAULT_SCHEMA_NAME.equalsIgnoreCase(this.schemaName);
    }

    public double getBloatPercentageThreshold() {
        return this.bloatPercentageThreshold;
    }

    public double getRemainingPercentageThreshold() {
        return this.remainingPercentageThreshold;
    }

    public String toString() {
        return PgContext.class.getSimpleName() + "{schemaName='" + this.schemaName + "', bloatPercentageThreshold=" + this.bloatPercentageThreshold + ", remainingPercentageThreshold=" + this.remainingPercentageThreshold + "}";
    }

    public String enrichWithSchema(String objectName) {
        Validators.notBlank(objectName, "objectName");
        if (this.isDefaultSchema()) {
            return objectName;
        }
        return this.enrichWithSchemaIfNeed(objectName);
    }

    private String enrichWithSchemaIfNeed(String objectName) {
        String prefix = this.schemaName + ".";
        if (objectName.toLowerCase(Locale.ROOT).startsWith(prefix)) {
            return objectName;
        }
        return prefix + objectName;
    }

    public static PgContext of(String schemaName, double bloatPercentageThreshold, double remainingPercentageThreshold) {
        return new PgContext(schemaName, bloatPercentageThreshold, remainingPercentageThreshold);
    }

    public static PgContext of(String schemaName, double bloatPercentageThreshold) {
        return new PgContext(schemaName, bloatPercentageThreshold, 10.0);
    }

    public static PgContext of(String schemaName) {
        return PgContext.of(schemaName, 10.0);
    }

    public static PgContext ofDefault() {
        return PgContext.of(DEFAULT_SCHEMA_NAME);
    }

    public static String enrichWith(String objectName, PgContext pgContext) {
        Objects.requireNonNull(pgContext, "pgContext cannot be null");
        return pgContext.enrichWithSchema(objectName);
    }
}

