/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.dbobject;

import java.util.Objects;

public enum PgObjectType {
    TABLE("table"),
    PARTITIONED_TABLE("partitioned table"),
    INDEX("index"),
    PARTITIONED_INDEX("partitioned index"),
    SEQUENCE("sequence"),
    VIEW("view"),
    MATERIALIZED_VIEW("materialized view"),
    FUNCTION("function"),
    CONSTRAINT("constraint");

    private final String objectType;

    private PgObjectType(String objectType) {
        this.objectType = Objects.requireNonNull(objectType, "objectType");
    }

    public static PgObjectType valueFrom(String objectType) {
        Objects.requireNonNull(objectType, "objectType cannot be null");
        for (PgObjectType pgObjectType : PgObjectType.values()) {
            if (!pgObjectType.objectType.equalsIgnoreCase(objectType)) continue;
            return pgObjectType;
        }
        throw new IllegalArgumentException("Unknown objectType: " + objectType);
    }
}

