/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.index.IndexesAware;
import io.github.mfvanek.pg.model.index.utils.DuplicatedIndexesParser;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class DuplicatedIndexes
implements DbObject,
TableNameAware,
IndexesAware {
    private static final Comparator<Index> INDEX_WITH_SIZE_COMPARATOR = Comparator.comparing(Index::getTableName).thenComparing(Index::getIndexName).thenComparing(Index::getIndexSizeInBytes);
    private final List<Index> indexes;
    private final long totalSize;
    private final List<String> indexesNames;

    private DuplicatedIndexes(Collection<Index> duplicatedIndexes) {
        List<Index> defensiveCopy = List.copyOf(Objects.requireNonNull(duplicatedIndexes, "duplicatedIndexes cannot be null"));
        Validators.validateThatTableIsTheSame(defensiveCopy);
        this.indexes = defensiveCopy.stream().sorted(INDEX_WITH_SIZE_COMPARATOR).toList();
        this.totalSize = this.indexes.stream().mapToLong(Index::getIndexSizeInBytes).sum();
        this.indexesNames = this.indexes.stream().map(Index::getIndexName).toList();
    }

    @Override
    public String getName() {
        return String.join((CharSequence)",", this.indexesNames);
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.INDEX;
    }

    @Override
    public String getTableName() {
        return this.indexes.get(0).getTableName();
    }

    public List<Index> getDuplicatedIndexes() {
        return this.indexes;
    }

    @Override
    public List<Index> getIndexes() {
        return List.copyOf(this.indexes);
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public List<String> getIndexNames() {
        return this.indexesNames;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DuplicatedIndexes)) {
            return false;
        }
        DuplicatedIndexes that = (DuplicatedIndexes)other;
        return Objects.equals(this.indexes, that.indexes);
    }

    public int hashCode() {
        return Objects.hash(this.indexes);
    }

    public String toString() {
        return DuplicatedIndexes.class.getSimpleName() + "{tableName='" + this.getTableName() + "', totalSize=" + this.totalSize + ", indexes=" + this.indexes + "}";
    }

    public static DuplicatedIndexes of(Collection<Index> duplicatedIndexes) {
        return new DuplicatedIndexes(duplicatedIndexes);
    }

    public static DuplicatedIndexes of(String tableName, String duplicatedAsString) {
        Validators.tableNameNotBlank(tableName);
        List<Map.Entry<String, Long>> indexesWithNameAndSize = DuplicatedIndexesParser.parseAsIndexNameAndSize(Validators.notBlank(duplicatedAsString, "duplicatedAsString"));
        List<Index> duplicatedIndexes = indexesWithNameAndSize.stream().map(e -> Index.of(tableName, (String)e.getKey(), (Long)e.getValue())).toList();
        return new DuplicatedIndexes(duplicatedIndexes);
    }

    public static DuplicatedIndexes of(Index firstIndex, Index secondIndex, Index ... otherIndexes) {
        return new DuplicatedIndexes(DuplicatedIndexesParser.combine((TableNameAware)firstIndex, (TableNameAware)secondIndex, (TableNameAware[])otherIndexes));
    }
}

