/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.column.ColumnsAware;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.index.AbstractIndexAware;
import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class IndexWithColumns
extends AbstractIndexAware
implements ColumnsAware,
Comparable<IndexWithColumns> {
    private final List<Column> columns;

    private IndexWithColumns(Index index, List<Column> columns) {
        super(index);
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(columns, "columns cannot be null"));
        Validators.validateThatTableIsTheSame(index.getTableName(), defensiveCopy);
        this.columns = defensiveCopy;
    }

    @Override
    public List<ColumnNameAware> getColumns() {
        return List.copyOf(this.columns);
    }

    public String toString() {
        return IndexWithColumns.class.getSimpleName() + "{" + this.index.innerToString() + ", columns=" + this.columns + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexWithColumns)) {
            return false;
        }
        IndexWithColumns that = (IndexWithColumns)other;
        return Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hashCode(this.index);
    }

    @Override
    public int compareTo(IndexWithColumns other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.index.compareTo(other.index);
    }

    public static IndexWithColumns ofSingle(String tableName, String indexName, long indexSizeInBytes, Column column) {
        return IndexWithColumns.ofSingle(Index.of(tableName, indexName, indexSizeInBytes), column);
    }

    public static IndexWithColumns ofSingle(PgContext pgContext, String tableName, String indexName, long indexSizeInBytes, Column column) {
        return IndexWithColumns.ofSingle(Index.of(pgContext, tableName, indexName, indexSizeInBytes), column);
    }

    public static IndexWithColumns ofSingle(Index index, Column column) {
        List<Column> columns = List.of(Objects.requireNonNull(column, "column cannot be null"));
        return IndexWithColumns.of(index, columns);
    }

    public static IndexWithColumns ofNullable(PgContext pgContext, String tableName, String indexName, String columnName) {
        return IndexWithColumns.ofSingle(Index.of(pgContext, tableName, indexName), Column.ofNullable(pgContext, tableName, columnName));
    }

    public static IndexWithColumns ofNotNull(PgContext pgContext, String tableName, String indexName, String columnName) {
        return IndexWithColumns.ofSingle(Index.of(pgContext, tableName, indexName), Column.ofNotNull(pgContext, tableName, columnName));
    }

    public static IndexWithColumns ofColumns(String tableName, String indexName, long indexSizeInBytes, List<Column> columns) {
        return IndexWithColumns.of(Index.of(tableName, indexName, indexSizeInBytes), columns);
    }

    public static IndexWithColumns ofColumns(PgContext pgContext, String tableName, String indexName, long indexSizeInBytes, List<Column> columns) {
        return IndexWithColumns.of(Index.of(pgContext, tableName, indexName, indexSizeInBytes), columns);
    }

    public static IndexWithColumns ofColumns(PgContext pgContext, String tableName, String indexName, List<Column> columns) {
        return IndexWithColumns.ofColumns(pgContext, tableName, indexName, 0L, columns);
    }

    public static IndexWithColumns of(Index index, List<Column> columns) {
        return new IndexWithColumns(index, columns);
    }
}

