/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.index.AbstractIndexAware;
import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class UnusedIndex
extends AbstractIndexAware
implements Comparable<UnusedIndex> {
    private final long indexScans;

    private UnusedIndex(Index index, long indexScans) {
        super(index);
        this.indexScans = Validators.countNotNegative(indexScans, "indexScans");
    }

    public long getIndexScans() {
        return this.indexScans;
    }

    public String toString() {
        return UnusedIndex.class.getSimpleName() + "{" + this.index.innerToString() + ", indexScans=" + this.indexScans + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnusedIndex)) {
            return false;
        }
        UnusedIndex that = (UnusedIndex)other;
        return Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hashCode(this.index);
    }

    @Override
    public int compareTo(UnusedIndex other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.index.compareTo(other.index);
    }

    public static UnusedIndex of(String tableName, String indexName, long indexSizeInBytes, long indexScans) {
        return UnusedIndex.of(Index.of(tableName, indexName, indexSizeInBytes), indexScans);
    }

    public static UnusedIndex of(PgContext pgContext, String tableName, String indexName, long indexSizeInBytes, long indexScans) {
        return UnusedIndex.of(Index.of(pgContext, tableName, indexName, indexSizeInBytes), indexScans);
    }

    public static UnusedIndex of(String tableName, String indexName) {
        return UnusedIndex.of(tableName, indexName, 0L, 0L);
    }

    public static UnusedIndex of(PgContext pgContext, String tableName, String indexName) {
        return UnusedIndex.of(pgContext, tableName, indexName, 0L, 0L);
    }

    public static UnusedIndex of(Index index, long indexScans) {
        return new UnusedIndex(index, indexScans);
    }
}

