/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index.utils;

import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class DuplicatedIndexesParser {
    private DuplicatedIndexesParser() {
        throw new UnsupportedOperationException();
    }

    public static List<Map.Entry<String, Long>> parseAsIndexNameAndSize(String duplicatedAsString) {
        Validators.notBlank(duplicatedAsString, "duplicatedAsString");
        String[] indexes = duplicatedAsString.split("; ");
        return Arrays.stream(indexes).map(s -> s.split(",")).filter(a -> a[0].trim().startsWith("idx=") && a[1].trim().startsWith("size=")).map(a -> {
            String indexName = a[0].trim().substring("idx=".length());
            String sizeAsString = a[1].trim().substring("size=".length());
            return Map.entry(indexName, Long.valueOf(sizeAsString));
        }).toList();
    }

    @SafeVarargs
    public static <T extends TableNameAware & DbObject> List<T> combine(T firstObject, T secondObject, T ... otherObjects) {
        Objects.requireNonNull(firstObject, "firstObject cannot be null");
        Objects.requireNonNull(secondObject, "secondObject cannot be null");
        if (Stream.of(otherObjects).anyMatch(x$0 -> Objects.isNull(x$0))) {
            throw new IllegalArgumentException("otherObjects cannot contain nulls");
        }
        Stream<TableNameAware> basePart = Stream.of(firstObject, secondObject);
        return Stream.concat(basePart, Stream.of(otherObjects)).toList();
    }
}

