/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class AbstractSkipTablesPredicate
implements Predicate<DbObject> {
    private final Set<String> fullyQualifiedTableNamesToSkip;

    AbstractSkipTablesPredicate(PgContext pgContext, Collection<String> rawTableNamesToSkip) {
        this.fullyQualifiedTableNamesToSkip = AbstractSkipTablesPredicate.prepareFullyQualifiedNamesToSkip(pgContext, rawTableNamesToSkip);
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (!this.fullyQualifiedTableNamesToSkip.isEmpty() && dbObject instanceof TableNameAware) {
            TableNameAware t = (TableNameAware)((Object)dbObject);
            return !this.fullyQualifiedTableNamesToSkip.contains(t.getTableName().toLowerCase(Locale.ROOT));
        }
        return true;
    }

    static Set<String> prepareFullyQualifiedNamesToSkip(PgContext pgContext, Collection<String> rawNamesToSkip) {
        Objects.requireNonNull(pgContext, "pgContext cannot be null");
        return Objects.requireNonNull(rawNamesToSkip, "rawNamesToSkip cannot be null").stream().map(pgContext::enrichWithSchema).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableSet());
    }

    static Set<String> prepareNamesToSkip(Collection<String> rawNamesToSkip) {
        return Objects.requireNonNull(rawNamesToSkip, "rawNamesToSkip cannot be null").stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableSet());
    }

    static Set<String> prepareSingleNameToSkip(String rawNameToSkip, String argumentName) {
        return Set.of(Validators.notBlank(rawNameToSkip, argumentName));
    }
}

