/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.bloat.BloatAware;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.function.Predicate;

public final class SkipBloatUnderThresholdPredicate
implements Predicate<DbObject> {
    private final long sizeThresholdInBytes;
    private final double percentageThreshold;

    private SkipBloatUnderThresholdPredicate(long sizeThresholdInBytes, double percentageThreshold) {
        this.sizeThresholdInBytes = Validators.sizeNotNegative(sizeThresholdInBytes, "sizeThresholdInBytes");
        this.percentageThreshold = Validators.validPercent(percentageThreshold, "percentageThreshold");
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (this.sizeThresholdInBytes == 0L && this.percentageThreshold == 0.0) {
            return true;
        }
        if (!(dbObject instanceof BloatAware)) {
            return true;
        }
        BloatAware bloatAware = (BloatAware)((Object)dbObject);
        return bloatAware.getBloatSizeInBytes() >= this.sizeThresholdInBytes && bloatAware.getBloatPercentage() >= this.percentageThreshold;
    }

    public static Predicate<DbObject> of(long sizeThresholdInBytes, double percentageThreshold) {
        return new SkipBloatUnderThresholdPredicate(sizeThresholdInBytes, percentageThreshold);
    }
}

