/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.constraint.ConstraintNameAware;
import io.github.mfvanek.pg.model.constraint.ConstraintsAware;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.predicates.AbstractSkipTablesPredicate;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;

public final class SkipByConstraintNamePredicate
implements Predicate<DbObject> {
    private final Set<String> constraintNamesToSkip;

    private SkipByConstraintNamePredicate(Collection<String> constraintNamesToSkip) {
        this.constraintNamesToSkip = AbstractSkipTablesPredicate.prepareNamesToSkip(constraintNamesToSkip);
    }

    private SkipByConstraintNamePredicate(String constraintNameToSkip) {
        this(AbstractSkipTablesPredicate.prepareSingleNameToSkip(constraintNameToSkip, "constraintNameToSkip"));
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (this.constraintNamesToSkip.isEmpty()) {
            return true;
        }
        if (dbObject instanceof ConstraintNameAware) {
            ConstraintNameAware c = (ConstraintNameAware)((Object)dbObject);
            return !this.constraintNamesToSkip.contains(c.getConstraintName().toLowerCase(Locale.ROOT));
        }
        if (dbObject instanceof ConstraintsAware) {
            ConstraintsAware cs = (ConstraintsAware)((Object)dbObject);
            for (ConstraintNameAware c : cs.getConstraints()) {
                if (!this.constraintNamesToSkip.contains(c.getConstraintName().toLowerCase(Locale.ROOT))) continue;
                return false;
            }
        }
        return true;
    }

    public static Predicate<DbObject> ofName(String constraintNameToSkip) {
        return new SkipByConstraintNamePredicate(constraintNameToSkip);
    }

    public static Predicate<DbObject> of(Collection<String> constraintNamesToSkip) {
        return new SkipByConstraintNamePredicate(constraintNamesToSkip);
    }
}

