/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.predicates;

import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.index.IndexSizeAware;
import io.github.mfvanek.pg.model.predicates.AbstractFilterBySize;
import java.util.function.Predicate;

public final class SkipSmallIndexesPredicate
extends AbstractFilterBySize {
    private SkipSmallIndexesPredicate(long thresholdInBytes) {
        super(thresholdInBytes);
    }

    @Override
    public boolean test(DbObject dbObject) {
        if (this.thresholdInBytes == 0L) {
            return true;
        }
        if (!(dbObject instanceof IndexSizeAware)) {
            return true;
        }
        IndexSizeAware indexSizeAware = (IndexSizeAware)((Object)dbObject);
        return indexSizeAware.getIndexSizeInBytes() >= this.thresholdInBytes;
    }

    public static Predicate<DbObject> of(long thresholdInBytes) {
        return new SkipSmallIndexesPredicate(thresholdInBytes);
    }
}

