/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.settings;

import io.github.mfvanek.pg.model.settings.ParamNameAware;
import io.github.mfvanek.pg.model.settings.validation.ParamValidators;
import io.github.mfvanek.pg.model.validation.Validators;

public enum ImportantParam implements ParamNameAware
{
    SHARED_BUFFERS("shared_buffers", "128MB"),
    WORK_MEM("work_mem", "4MB"),
    MAINTENANCE_WORK_MEM("maintenance_work_mem", "64MB"),
    RANDOM_PAGE_COST("random_page_cost", "4"),
    LOG_MIN_DURATION_STATEMENT("log_min_duration_statement", "-1"),
    IDLE_IN_TRANSACTION_SESSION_TIMEOUT("idle_in_transaction_session_timeout", "0"),
    STATEMENT_TIMEOUT("statement_timeout", "0"),
    LOCK_TIMEOUT("lock_timeout", "0"),
    EFFECTIVE_CACHE_SIZE("effective_cache_size", "4GB"),
    TEMP_FILE_LIMIT("temp_file_limit", "-1");

    private final String name;
    private final String defaultValue;

    private ImportantParam(String name, String defaultValue) {
        this.name = Validators.notBlank(name, "name");
        this.defaultValue = ParamValidators.paramValueNotNull(defaultValue, "defaultValue for '" + name + "' cannot be null");
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return ImportantParam.class.getSimpleName() + "{name='" + this.name + "', defaultValue='" + this.defaultValue + "'}";
    }
}

