/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.table;

import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import io.github.mfvanek.pg.model.dbobject.PgObjectType;
import io.github.mfvanek.pg.model.table.TableSizeAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class Table
implements DbObject,
TableSizeAware,
Comparable<Table> {
    private final String tableName;
    private final long tableSizeInBytes;

    private Table(String tableName, long tableSizeInBytes) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.tableSizeInBytes = Validators.sizeNotNegative(tableSizeInBytes, "tableSizeInBytes");
    }

    @Override
    public String getName() {
        return this.getTableName();
    }

    @Override
    public PgObjectType getObjectType() {
        return PgObjectType.TABLE;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public long getTableSizeInBytes() {
        return this.tableSizeInBytes;
    }

    String innerToString() {
        return "tableName='" + this.tableName + "', tableSizeInBytes=" + this.tableSizeInBytes;
    }

    public String toString() {
        return Table.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Table)) {
            return false;
        }
        Table that = (Table)other;
        return Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    @Override
    public int compareTo(Table other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.tableName.compareTo(other.tableName);
    }

    public static Table of(String tableName, long tableSizeInBytes) {
        return new Table(tableName, tableSizeInBytes);
    }

    public static Table of(PgContext pgContext, String tableName, long tableSizeInBytes) {
        return Table.of(PgContext.enrichWith(tableName, pgContext), tableSizeInBytes);
    }

    public static Table of(String tableName) {
        return Table.of(tableName, 0L);
    }

    public static Table of(PgContext pgContext, String tableName) {
        Objects.requireNonNull(pgContext, "pgContext cannot be null");
        return Table.of(PgContext.enrichWith(tableName, pgContext));
    }
}

