/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.table;

import io.github.mfvanek.pg.model.bloat.BloatAware;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.table.AbstractTableAware;
import io.github.mfvanek.pg.model.table.Table;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class TableWithBloat
extends AbstractTableAware
implements BloatAware,
Comparable<TableWithBloat> {
    private final long bloatSizeInBytes;
    private final double bloatPercentage;

    private TableWithBloat(Table table, long bloatSizeInBytes, double bloatPercentage) {
        super(table);
        this.bloatSizeInBytes = Validators.sizeNotNegative(bloatSizeInBytes, "bloatSizeInBytes");
        this.bloatPercentage = Validators.validPercent(bloatPercentage, "bloatPercentage");
    }

    @Override
    public long getBloatSizeInBytes() {
        return this.bloatSizeInBytes;
    }

    @Override
    public double getBloatPercentage() {
        return this.bloatPercentage;
    }

    public String toString() {
        return TableWithBloat.class.getSimpleName() + "{" + this.table.innerToString() + ", bloatSizeInBytes=" + this.bloatSizeInBytes + ", bloatPercentage=" + this.bloatPercentage + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableWithBloat)) {
            return false;
        }
        TableWithBloat that = (TableWithBloat)other;
        return Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public int compareTo(TableWithBloat other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.table.compareTo(other.table);
    }

    public static TableWithBloat of(String tableName, long tableSizeInBytes, long bloatSizeInBytes, double bloatPercentage) {
        Table table = Table.of(tableName, tableSizeInBytes);
        return TableWithBloat.of(table, bloatSizeInBytes, bloatPercentage);
    }

    public static TableWithBloat of(PgContext pgContext, String tableName, long tableSizeInBytes, long bloatSizeInBytes, double bloatPercentage) {
        Table table = Table.of(pgContext, tableName, tableSizeInBytes);
        return TableWithBloat.of(table, bloatSizeInBytes, bloatPercentage);
    }

    public static TableWithBloat of(PgContext pgContext, String tableName) {
        return TableWithBloat.of(pgContext, tableName, 0L, 0L, 0.0);
    }

    public static TableWithBloat of(Table table, long bloatSizeInBytes, double bloatPercentage) {
        return new TableWithBloat(table, bloatSizeInBytes, bloatPercentage);
    }
}

