/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.table;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.column.ColumnsAware;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.table.AbstractTableAware;
import io.github.mfvanek.pg.model.table.Table;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class TableWithColumns
extends AbstractTableAware
implements ColumnsAware,
Comparable<TableWithColumns> {
    private final List<Column> columns;

    private TableWithColumns(Table table, List<Column> columns) {
        super(table);
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(columns, "columns cannot be null"));
        Validators.validateThatTableIsTheSame(table.getTableName(), defensiveCopy);
        this.columns = defensiveCopy;
    }

    @Override
    public List<ColumnNameAware> getColumns() {
        return List.copyOf(this.columns);
    }

    public String toString() {
        return TableWithColumns.class.getSimpleName() + "{" + this.table.innerToString() + ", columns=" + this.columns + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableWithColumns)) {
            return false;
        }
        TableWithColumns that = (TableWithColumns)other;
        return Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public int compareTo(TableWithColumns other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.table.compareTo(other.table);
    }

    public static TableWithColumns withoutColumns(Table table) {
        return new TableWithColumns(table, List.of());
    }

    public static TableWithColumns withoutColumns(PgContext pgContext, String tableName) {
        return new TableWithColumns(Table.of(pgContext, tableName), List.of());
    }

    public static TableWithColumns of(Table table, List<Column> columns) {
        return new TableWithColumns(table, columns);
    }

    public static TableWithColumns ofSingle(Table table, Column column) {
        return TableWithColumns.of(table, List.of(column));
    }

    public static TableWithColumns ofNotNullColumn(PgContext pgContext, String tableName, String columnName) {
        return TableWithColumns.ofSingle(Table.of(pgContext, tableName), Column.ofNotNull(pgContext, tableName, columnName));
    }

    public static TableWithColumns ofNullableColumn(PgContext pgContext, String tableName, String columnName) {
        return TableWithColumns.ofSingle(Table.of(pgContext, tableName), Column.ofNullable(pgContext, tableName, columnName));
    }
}

