/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.function;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StoredFunction
implements DbObject,
Comparable<StoredFunction> {
    private final String functionName;
    private final String functionSignature;

    private StoredFunction(@Nonnull String functionName, @Nonnull String functionSignature) {
        this.functionName = Validators.notBlank(functionName, "functionName");
        this.functionSignature = Objects.requireNonNull(functionSignature, "functionSignature cannot be null").trim();
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getFunctionName();
    }

    @Nonnull
    public String getFunctionName() {
        return this.functionName;
    }

    @Nonnull
    public String getFunctionSignature() {
        return this.functionSignature;
    }

    @Nonnull
    public String toString() {
        return StoredFunction.class.getSimpleName() + "{functionName='" + this.functionName + "', functionSignature='" + this.functionSignature + "'}";
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StoredFunction)) {
            return false;
        }
        StoredFunction that = (StoredFunction)other;
        return Objects.equals(this.functionName, that.functionName) && Objects.equals(this.functionSignature, that.functionSignature);
    }

    public final int hashCode() {
        return Objects.hash(this.functionName, this.functionSignature);
    }

    @Override
    public int compareTo(@Nonnull StoredFunction other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.functionName.equals(other.functionName)) {
            return this.functionName.compareTo(other.functionName);
        }
        return this.functionSignature.compareTo(other.functionSignature);
    }

    public static StoredFunction ofNoArgs(@Nonnull String functionName) {
        return new StoredFunction(functionName, "");
    }

    public static StoredFunction of(@Nonnull String functionName, @Nonnull String functionSignature) {
        return new StoredFunction(functionName, functionSignature);
    }
}

