/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.index.Index;
import io.github.mfvanek.pg.model.index.IndexWithSize;
import io.github.mfvanek.pg.model.index.utils.DuplicatedIndexesParser;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DuplicatedIndexes
implements DbObject,
TableNameAware {
    private static final Comparator<IndexWithSize> INDEX_WITH_SIZE_COMPARATOR = Comparator.comparing(Index::getTableName).thenComparing(Index::getIndexName).thenComparing(IndexWithSize::getIndexSizeInBytes);
    private final List<IndexWithSize> indexes;
    private final long totalSize;
    private final List<String> indexesNames;

    private DuplicatedIndexes(@Nonnull List<IndexWithSize> duplicatedIndexes) {
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(duplicatedIndexes, "duplicatedIndexes cannot be null"));
        DuplicatedIndexes.validateThatTableIsTheSame(defensiveCopy);
        this.indexes = defensiveCopy.stream().sorted(INDEX_WITH_SIZE_COMPARATOR).collect(Collectors.toUnmodifiableList());
        this.totalSize = this.indexes.stream().mapToLong(IndexWithSize::getIndexSizeInBytes).sum();
        this.indexesNames = this.indexes.stream().map(Index::getIndexName).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Nonnull
    public final String getName() {
        return String.join((CharSequence)",", this.indexesNames);
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.indexes.get(0).getTableName();
    }

    @Nonnull
    public List<IndexWithSize> getDuplicatedIndexes() {
        return this.indexes;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public List<String> getIndexNames() {
        return this.indexesNames;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DuplicatedIndexes)) {
            return false;
        }
        DuplicatedIndexes that = (DuplicatedIndexes)other;
        return Objects.equals(this.indexes, that.indexes);
    }

    public final int hashCode() {
        return Objects.hash(this.indexes);
    }

    @Nonnull
    public String toString() {
        return DuplicatedIndexes.class.getSimpleName() + "{tableName='" + this.getTableName() + "', totalSize=" + this.totalSize + ", indexes=" + this.indexes + "}";
    }

    @Nonnull
    public static DuplicatedIndexes of(@Nonnull List<IndexWithSize> duplicatedIndexes) {
        return new DuplicatedIndexes(duplicatedIndexes);
    }

    @Nonnull
    public static DuplicatedIndexes of(@Nonnull String tableName, @Nonnull String duplicatedAsString) {
        Validators.tableNameNotBlank(tableName);
        List<Map.Entry<String, Long>> indexesWithNameAndSize = DuplicatedIndexesParser.parseAsIndexNameAndSize(Validators.notBlank(duplicatedAsString, "duplicatedAsString"));
        List<IndexWithSize> duplicatedIndexes = indexesWithNameAndSize.stream().map(e -> IndexWithSize.of(tableName, (String)e.getKey(), (Long)e.getValue())).collect(Collectors.toUnmodifiableList());
        return new DuplicatedIndexes(duplicatedIndexes);
    }

    @Nonnull
    public static DuplicatedIndexes of(@Nonnull IndexWithSize firstIndex, @Nonnull IndexWithSize secondIndex, IndexWithSize ... otherIndexes) {
        Objects.requireNonNull(firstIndex, "firstIndex cannot be null");
        Objects.requireNonNull(secondIndex, "secondIndex cannot be null");
        if (Stream.of(otherIndexes).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("otherIndexes cannot contain nulls");
        }
        Stream<IndexWithSize> basePart = Stream.of(firstIndex, secondIndex);
        return new DuplicatedIndexes(Stream.concat(basePart, Stream.of(otherIndexes)).collect(Collectors.toUnmodifiableList()));
    }

    private static void validateThatTableIsTheSame(@Nonnull List<? extends TableNameAware> duplicatedIndexes) {
        String tableName = DuplicatedIndexes.validateThatContainsAtLeastTwoRows(duplicatedIndexes).get(0).getTableName();
        Validators.validateThatTableIsTheSame(tableName, duplicatedIndexes);
    }

    @Nonnull
    private static <T> List<T> validateThatContainsAtLeastTwoRows(@Nonnull List<T> duplicatedIndexes) {
        int size = Objects.requireNonNull(duplicatedIndexes).size();
        if (0 == size) {
            throw new IllegalArgumentException("duplicatedIndexes cannot be empty");
        }
        if (size < 2) {
            throw new IllegalArgumentException("duplicatedIndexes should contains at least two rows");
        }
        return duplicatedIndexes;
    }
}

