/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.settings;

import io.github.mfvanek.pg.model.MemoryUnit;
import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.settings.ServerSpecification;
import javax.annotation.Nonnull;

public class ServerSpecificationBuilder {
    private int cpuCoresAmount = 1;
    private long memoryAmountInBytes = MemoryUnit.GB.convertToBytes(1);
    private boolean hasSSD = false;

    ServerSpecificationBuilder() {
    }

    @Nonnull
    public ServerSpecificationBuilder withCpuCores(int cpuCoresAmount) {
        Validators.valueIsPositive(cpuCoresAmount, "cpuCoresAmount");
        this.cpuCoresAmount = cpuCoresAmount;
        return this;
    }

    @Nonnull
    public ServerSpecificationBuilder withMemoryAmount(int unitsCount, MemoryUnit unit) {
        Validators.valueIsPositive(unitsCount, "unitsCount");
        this.memoryAmountInBytes = unit.convertToBytes(unitsCount);
        return this;
    }

    @Nonnull
    public ServerSpecificationBuilder withSSD() {
        this.hasSSD = true;
        return this;
    }

    @Nonnull
    public ServerSpecification build() {
        return new ServerSpecification(this.cpuCoresAmount, this.memoryAmountInBytes, this.hasSSD);
    }

    @Nonnull
    public String toString() {
        return ServerSpecificationBuilder.class.getSimpleName() + "{cpuCoresAmount=" + this.cpuCoresAmount + ", memoryAmountInBytes=" + this.memoryAmountInBytes + ", hasSSD=" + this.hasSSD + "}";
    }
}

