/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ForeignKey
implements DbObject,
TableNameAware {
    private final String tableName;
    private final String constraintName;
    private final List<Column> columnsInConstraint;

    private ForeignKey(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull List<Column> columnsInConstraint) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.constraintName = Validators.notBlank(constraintName, "constraintName");
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(columnsInConstraint, "columnsInConstraint cannot be null"));
        Validators.validateThatNotEmpty(defensiveCopy);
        Validators.validateThatTableIsTheSame(tableName, defensiveCopy);
        this.columnsInConstraint = defensiveCopy;
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getConstraintName();
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getConstraintName() {
        return this.constraintName;
    }

    @Nonnull
    public List<Column> getColumnsInConstraint() {
        return this.columnsInConstraint;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForeignKey)) {
            return false;
        }
        ForeignKey that = (ForeignKey)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.constraintName, that.constraintName) && Objects.equals(this.columnsInConstraint, that.columnsInConstraint);
    }

    public final int hashCode() {
        return Objects.hash(this.tableName, this.constraintName, this.columnsInConstraint);
    }

    @Nonnull
    public String toString() {
        return ForeignKey.class.getSimpleName() + "{tableName='" + this.tableName + "', constraintName='" + this.constraintName + "', columnsInConstraint=" + this.columnsInConstraint + "}";
    }

    @Nonnull
    public static ForeignKey of(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull List<Column> columnsInConstraint) {
        return new ForeignKey(tableName, constraintName, columnsInConstraint);
    }

    @Nonnull
    public static ForeignKey ofColumn(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull Column column) {
        return new ForeignKey(tableName, constraintName, List.of(Objects.requireNonNull(column, "column cannot be null")));
    }

    @Nonnull
    public static ForeignKey ofNotNullColumn(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull String columnName) {
        return ForeignKey.ofColumn(tableName, constraintName, Column.ofNotNull(tableName, columnName));
    }

    @Nonnull
    public static ForeignKey ofNullableColumn(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull String columnName) {
        return ForeignKey.ofColumn(tableName, constraintName, Column.ofNullable(tableName, columnName));
    }
}

