/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.index.IndexWithSize;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IndexWithNulls
extends IndexWithSize {
    private final Column nullableColumn;

    private IndexWithNulls(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull Column nullableColumn) {
        super(tableName, indexName, indexSizeInBytes);
        Objects.requireNonNull(nullableColumn, "nullableColumn cannot be null");
        Validators.validateThatTableIsTheSame(tableName, List.of(nullableColumn));
        this.nullableColumn = nullableColumn;
    }

    @Nonnull
    public Column getNullableColumn() {
        return this.nullableColumn;
    }

    @Override
    @Nonnull
    public String toString() {
        return IndexWithNulls.class.getSimpleName() + "{" + this.innerToString() + ", nullableColumn=" + this.nullableColumn + "}";
    }

    public static IndexWithNulls of(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull String nullableColumnName) {
        return new IndexWithNulls(tableName, indexName, indexSizeInBytes, Column.ofNullable(tableName, nullableColumnName));
    }
}

