/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.table;

import io.github.mfvanek.pg.model.table.AbstractTableAware;
import io.github.mfvanek.pg.model.table.Table;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWithMissingIndex
extends AbstractTableAware
implements Comparable<TableWithMissingIndex> {
    private final long seqScans;
    private final long indexScans;

    private TableWithMissingIndex(@Nonnull Table table, long seqScans, long indexScans) {
        super(table);
        this.seqScans = Validators.countNotNegative(seqScans, "seqScans");
        this.indexScans = Validators.countNotNegative(indexScans, "indexScans");
    }

    public long getSeqScans() {
        return this.seqScans;
    }

    public long getIndexScans() {
        return this.indexScans;
    }

    @Nonnull
    public String toString() {
        return TableWithMissingIndex.class.getSimpleName() + "{" + this.table.innerToString() + ", seqScans=" + this.seqScans + ", indexScans=" + this.indexScans + "}";
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TableWithMissingIndex)) {
            return false;
        }
        TableWithMissingIndex that = (TableWithMissingIndex)other;
        return Objects.equals(this.table, that.table);
    }

    public final int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public int compareTo(@Nonnull TableWithMissingIndex other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.table.compareTo(other.table);
    }

    public static TableWithMissingIndex of(@Nonnull String tableName, long tableSizeInBytes, long seqScans, long indexScans) {
        Table table = Table.of(tableName, tableSizeInBytes);
        return TableWithMissingIndex.of(table, seqScans, indexScans);
    }

    public static TableWithMissingIndex of(@Nonnull Table table, long seqScans, long indexScans) {
        return new TableWithMissingIndex(table, seqScans, indexScans);
    }
}

