/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.spring;

import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DatabaseStructureHealthCondition
extends SpringBootCondition {
    private static final String PROPERTY_NAME = "spring.datasource.url";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"pg.index.health.test PostgreSQL condition", (Object[])new Object[0]);
        String jdbcUrl = DatabaseStructureHealthCondition.getJdbcUrl(context);
        if (jdbcUrl != null && !jdbcUrl.isBlank()) {
            if (jdbcUrl.startsWith("jdbc:postgresql://")) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("found PostgreSQL connection " + jdbcUrl)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("not PostgreSQL connection"));
        }
        return ConditionOutcome.match((ConditionMessage)message.didNotFind(PROPERTY_NAME).items(new Object[0]));
    }

    @Nullable
    private static String getJdbcUrl(ConditionContext context) {
        return (String)Binder.get((Environment)context.getEnvironment()).bind(PROPERTY_NAME, String.class).orElse(null);
    }
}

