/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.spring;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.core.checks.host.BtreeIndexesOnArrayColumnsCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ColumnsNotFollowingNamingConventionCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ColumnsWithFixedLengthVarcharCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ColumnsWithJsonTypeCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ColumnsWithMoneyTypeCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ColumnsWithSerialTypesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ColumnsWithoutDescriptionCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.DuplicatedForeignKeysCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.DuplicatedIndexesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ForeignKeysNotCoveredWithIndexCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ForeignKeysWithUnmatchedColumnTypeCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.FunctionsWithoutDescriptionCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IndexesWithBloatCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IndexesWithBooleanCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IndexesWithNullValuesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IndexesWithTimestampInTheMiddleCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IndexesWithUnnecessaryWhereClauseCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IntersectedForeignKeysCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.IntersectedIndexesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.InvalidIndexesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.NotValidConstraintsCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.ObjectsNotFollowingNamingConventionCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.PossibleObjectNameOverflowCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.PrimaryKeysThatMostLikelyNaturalKeysCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.PrimaryKeysWithSerialTypesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.PrimaryKeysWithVarcharCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.SequenceOverflowCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.TablesNotLinkedToOthersCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.TablesWithBloatCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.TablesWithMissingIndexesCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.TablesWithZeroOrOneColumnCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.TablesWithoutDescriptionCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.TablesWithoutPrimaryKeyCheckOnHost;
import io.github.mfvanek.pg.core.checks.host.UnusedIndexesCheckOnHost;
import io.github.mfvanek.pg.core.statistics.StatisticsMaintenanceOnHost;
import io.github.mfvanek.pg.core.statistics.StatisticsMaintenanceOnHostImpl;
import io.github.mfvanek.pg.spring.DatabaseStructureHealthAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={DatabaseStructureHealthAutoConfiguration.class})
@ConditionalOnBean(value={PgConnection.class})
public class DatabaseStructureChecksAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={DuplicatedIndexesCheckOnHost.class})
    @ConditionalOnMissingBean
    public DuplicatedIndexesCheckOnHost duplicatedIndexesCheckOnHost(PgConnection pgConnection) {
        return new DuplicatedIndexesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ForeignKeysNotCoveredWithIndexCheckOnHost.class})
    @ConditionalOnMissingBean
    public ForeignKeysNotCoveredWithIndexCheckOnHost foreignKeysNotCoveredWithIndexCheckOnHost(PgConnection pgConnection) {
        return new ForeignKeysNotCoveredWithIndexCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IndexesWithBloatCheckOnHost.class})
    @ConditionalOnMissingBean
    public IndexesWithBloatCheckOnHost indexesWithBloatCheckOnHost(PgConnection pgConnection) {
        return new IndexesWithBloatCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IndexesWithNullValuesCheckOnHost.class})
    @ConditionalOnMissingBean
    public IndexesWithNullValuesCheckOnHost indexesWithNullValuesCheckOnHost(PgConnection pgConnection) {
        return new IndexesWithNullValuesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IntersectedIndexesCheckOnHost.class})
    @ConditionalOnMissingBean
    public IntersectedIndexesCheckOnHost intersectedIndexesCheckOnHost(PgConnection pgConnection) {
        return new IntersectedIndexesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={InvalidIndexesCheckOnHost.class})
    @ConditionalOnMissingBean
    public InvalidIndexesCheckOnHost invalidIndexesCheckOnHost(PgConnection pgConnection) {
        return new InvalidIndexesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={TablesWithBloatCheckOnHost.class})
    @ConditionalOnMissingBean
    public TablesWithBloatCheckOnHost tablesWithBloatCheckOnHost(PgConnection pgConnection) {
        return new TablesWithBloatCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={TablesWithMissingIndexesCheckOnHost.class})
    @ConditionalOnMissingBean
    public TablesWithMissingIndexesCheckOnHost tablesWithMissingIndexesCheckOnHost(PgConnection pgConnection) {
        return new TablesWithMissingIndexesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={TablesWithoutPrimaryKeyCheckOnHost.class})
    @ConditionalOnMissingBean
    public TablesWithoutPrimaryKeyCheckOnHost tablesWithoutPrimaryKeyCheckOnHost(PgConnection pgConnection) {
        return new TablesWithoutPrimaryKeyCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={UnusedIndexesCheckOnHost.class})
    @ConditionalOnMissingBean
    public UnusedIndexesCheckOnHost unusedIndexesCheckOnHost(PgConnection pgConnection) {
        return new UnusedIndexesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={TablesWithoutDescriptionCheckOnHost.class})
    @ConditionalOnMissingBean
    public TablesWithoutDescriptionCheckOnHost tablesWithoutDescriptionCheckOnHost(PgConnection pgConnection) {
        return new TablesWithoutDescriptionCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ColumnsWithoutDescriptionCheckOnHost.class})
    @ConditionalOnMissingBean
    public ColumnsWithoutDescriptionCheckOnHost columnsWithoutDescriptionCheckOnHost(PgConnection pgConnection) {
        return new ColumnsWithoutDescriptionCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ColumnsWithJsonTypeCheckOnHost.class})
    @ConditionalOnMissingBean
    public ColumnsWithJsonTypeCheckOnHost columnsWithJsonTypeCheckOnHost(PgConnection pgConnection) {
        return new ColumnsWithJsonTypeCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ColumnsWithSerialTypesCheckOnHost.class})
    @ConditionalOnMissingBean
    public ColumnsWithSerialTypesCheckOnHost columnsWithSerialTypesCheckOnHost(PgConnection pgConnection) {
        return new ColumnsWithSerialTypesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={FunctionsWithoutDescriptionCheckOnHost.class})
    @ConditionalOnMissingBean
    public FunctionsWithoutDescriptionCheckOnHost functionsWithoutDescriptionCheckOnHost(PgConnection pgConnection) {
        return new FunctionsWithoutDescriptionCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IndexesWithBooleanCheckOnHost.class})
    @ConditionalOnMissingBean
    public IndexesWithBooleanCheckOnHost indexesWithBooleanCheckOnHost(PgConnection pgConnection) {
        return new IndexesWithBooleanCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={NotValidConstraintsCheckOnHost.class})
    @ConditionalOnMissingBean
    public NotValidConstraintsCheckOnHost notValidConstraintsCheckOnHost(PgConnection pgConnection) {
        return new NotValidConstraintsCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={BtreeIndexesOnArrayColumnsCheckOnHost.class})
    @ConditionalOnMissingBean
    public BtreeIndexesOnArrayColumnsCheckOnHost btreeIndexesOnArrayColumnsCheckOnHost(PgConnection pgConnection) {
        return new BtreeIndexesOnArrayColumnsCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={SequenceOverflowCheckOnHost.class})
    @ConditionalOnMissingBean
    public SequenceOverflowCheckOnHost sequenceOverflowCheckOnHost(PgConnection pgConnection) {
        return new SequenceOverflowCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={PrimaryKeysWithSerialTypesCheckOnHost.class})
    @ConditionalOnMissingBean
    public PrimaryKeysWithSerialTypesCheckOnHost primaryKeysWithSerialTypesCheckOnHost(PgConnection pgConnection) {
        return new PrimaryKeysWithSerialTypesCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={DuplicatedForeignKeysCheckOnHost.class})
    @ConditionalOnMissingBean
    public DuplicatedForeignKeysCheckOnHost duplicatedForeignKeysCheckOnHost(PgConnection pgConnection) {
        return new DuplicatedForeignKeysCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IntersectedForeignKeysCheckOnHost.class})
    @ConditionalOnMissingBean
    public IntersectedForeignKeysCheckOnHost intersectedForeignKeysCheckOnHost(PgConnection pgConnection) {
        return new IntersectedForeignKeysCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={PossibleObjectNameOverflowCheckOnHost.class})
    @ConditionalOnMissingBean
    public PossibleObjectNameOverflowCheckOnHost possibleObjectNameOverflowCheckOnHost(PgConnection pgConnection) {
        return new PossibleObjectNameOverflowCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={TablesNotLinkedToOthersCheckOnHost.class})
    @ConditionalOnMissingBean
    public TablesNotLinkedToOthersCheckOnHost tablesNotLinkedToOthersCheckOnHost(PgConnection pgConnection) {
        return new TablesNotLinkedToOthersCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ForeignKeysWithUnmatchedColumnTypeCheckOnHost.class})
    @ConditionalOnMissingBean
    public ForeignKeysWithUnmatchedColumnTypeCheckOnHost foreignKeysWithUnmatchedColumnTypeCheckOnHost(PgConnection pgConnection) {
        return new ForeignKeysWithUnmatchedColumnTypeCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={TablesWithZeroOrOneColumnCheckOnHost.class})
    @ConditionalOnMissingBean
    public TablesWithZeroOrOneColumnCheckOnHost tablesWithZeroOrOneColumnCheckOnHost(PgConnection pgConnection) {
        return new TablesWithZeroOrOneColumnCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ObjectsNotFollowingNamingConventionCheckOnHost.class})
    @ConditionalOnMissingBean
    public ObjectsNotFollowingNamingConventionCheckOnHost objectsNotFollowingNamingConventionCheckOnHost(PgConnection pgConnection) {
        return new ObjectsNotFollowingNamingConventionCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ColumnsNotFollowingNamingConventionCheckOnHost.class})
    @ConditionalOnMissingBean
    public ColumnsNotFollowingNamingConventionCheckOnHost columnsNotFollowingNamingConventionCheckOnHost(PgConnection pgConnection) {
        return new ColumnsNotFollowingNamingConventionCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={PrimaryKeysWithVarcharCheckOnHost.class})
    @ConditionalOnMissingBean
    public PrimaryKeysWithVarcharCheckOnHost primaryKeysWithVarcharCheckOnHost(PgConnection pgConnection) {
        return new PrimaryKeysWithVarcharCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ColumnsWithFixedLengthVarcharCheckOnHost.class})
    @ConditionalOnMissingBean
    public ColumnsWithFixedLengthVarcharCheckOnHost columnsWithFixedLengthVarcharCheckOnHost(PgConnection pgConnection) {
        return new ColumnsWithFixedLengthVarcharCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IndexesWithUnnecessaryWhereClauseCheckOnHost.class})
    @ConditionalOnMissingBean
    public IndexesWithUnnecessaryWhereClauseCheckOnHost indexesWithUnnecessaryWhereClauseCheckOnHost(PgConnection pgConnection) {
        return new IndexesWithUnnecessaryWhereClauseCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={PrimaryKeysThatMostLikelyNaturalKeysCheckOnHost.class})
    @ConditionalOnMissingBean
    public PrimaryKeysThatMostLikelyNaturalKeysCheckOnHost primaryKeysThatMostLikelyNaturalKeysCheckOnHost(PgConnection pgConnection) {
        return new PrimaryKeysThatMostLikelyNaturalKeysCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={ColumnsWithMoneyTypeCheckOnHost.class})
    @ConditionalOnMissingBean
    public ColumnsWithMoneyTypeCheckOnHost columnsWithMoneyTypeCheckOnHost(PgConnection pgConnection) {
        return new ColumnsWithMoneyTypeCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={IndexesWithTimestampInTheMiddleCheckOnHost.class})
    @ConditionalOnMissingBean
    public IndexesWithTimestampInTheMiddleCheckOnHost indexesWithTimestampInTheMiddleCheckOnHost(PgConnection pgConnection) {
        return new IndexesWithTimestampInTheMiddleCheckOnHost(pgConnection);
    }

    @Bean
    @ConditionalOnClass(value={StatisticsMaintenanceOnHost.class})
    @ConditionalOnMissingBean
    public StatisticsMaintenanceOnHost statisticsMaintenanceOnHost(PgConnection pgConnection) {
        return new StatisticsMaintenanceOnHostImpl(pgConnection);
    }
}

